#Cuadro X.1
#Correlaciones bivariadas simples.

########################################################
#Seccin modificable por el usuario
########################################################

#Lectura de la base de datos
datos<-read.csv2("Cuadro X.1.V.csv",header=T,encoding="latin1")

#Seleccin de variables de inters. 
varInteresX<-c("Edad.hembra")
varInteresY<-c("N.huevos")

#Seleccin de variables de agrupacin.
#varAgrupacion<-NULL
varAgrupacion<-c("Provincia")
#varAgrupacion<-c("Localidad")
#varAgrupacion<-c("Provincia","Localidad")

#Pruebas a realizar
#1.Coeficiente de correlacin de Pearson
#2.Coeficiente de correlacin de Spearman
#3.Coeficiente de correlacin de Kendall

pruebas<-c(1,2,3)

#Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro X.1.txt"

#######################################################
#Seccin que realiza el procedimiento
#######################################################

#Paquetes necesarios. ltm tiene la funcin rcor.test
require(ltm)

#Organizacin de los datos
valoresX<-unlist(datos[,varInteresX])
valoresY<-unlist(datos[,varInteresY])
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteresX)),varAgrupacion])
if(length(varAgrupacion)==1) names(agrupaciones)<-varAgrupacion
datos2<-data.frame(agrupaciones,varind=valoresX,vardep=valoresY)
attach(datos2)

#Clculo de los coeficientes de correlacin y valores de p
Coeficientes<-function(varind,vardep){
  listacoef<-NULL
  for (i in pruebas){
    if (i==1) listacoef<-c(listacoef,"Coeficiente de Pearson",by(datos2[,c("varind","vardep")],agrupaciones,function(x)rcor.test(x,method="pearson",use="complete.obs")))
    if (i==2) listacoef<-c(listacoef,"Coeficiente de Spearman",by(datos2[,c("varind","vardep")],agrupaciones,function(x)rcor.test(x,method="spearman",use="complete.obs")))
    if (i==3) listacoef<-c(listacoef,"Coeficiente de Kendall",by(datos2[,c("varind","vardep")],agrupaciones,function(x)rcor.test(x,method="kendall",use="complete.obs")))
    }
  return(listacoef)
}

#Muestra los resultados. Los coeficientes de correlaciones parciales se muestran en un vector por cada variable.
Resultados<-Coeficientes(datos2)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 sink()
}

#######################################################
#Seccin que muestra el grfico
#######################################################

#Grficas
plot(varind,vardep,pch=19)

detach(datos2)

